  // List of Nigerian names
  
  const nameParts1 = [
  "John","Mary","Michael","Sarah","David","Elizabeth","James","Patricia",
  "Robert","Jennifer","Daniel","Linda","William","Jessica","Matthew","Barbara",
  "Joseph","Susan","Christopher","Collins",
];
const nameParts2 = [
  "chi","meka","bayo","tola","lola","nke","dipo","femi","yemi","zoba",
  "seun","bola","chukwu","nna","kene","ife","obi","ayo","uche","nkem",
  "amaka","ogo","onye","uchechi","ka","naya","ndo","obioma","nnaji","ike",
  "somto","chim","jide","obinna","uzoma","okwu","okeke","ifeanyi","ngozi",
  "ebere","mmadu","akachi","uchechukwu","chinenye","uzochukwu","chioma","ebube",
  "ugochukwu","ozichukwu","adanna","odili","ugonna","ijeoma","oluchi","amobi",
  "ucheoma","okechukwu","chibuzor","nnem","obiageli","uzodinma","akunna","chizaram",
  "nwanne","uzodinma","somadina","obiajulu","chiamaka","eberechi","nkechi","ozor",
  "ugwu","ifechukwu","nnadozie","ogbonna","ikechukwu","nwaneri","izuchukwu","ozulumba",
  "okafor","okoro","mbakwe","ugochi","ije","okwuosa","nwanjoku","ogbu","uzoka",
  "uzoma","odum","nwakamma","uzo","uchegbu","obiefuna","onyeaka","ucheoma","obialo","chiemezie"
];

function generateNigerianNames(count = 1000) {
  let names = [];
  for (let i = 0; i < count; i++) {
    // 50/50 chance: pick from part1 or part2
    if (Math.random() < 0.5) {
      const part1 = nameParts1[Math.floor(Math.random() * nameParts1.length)];
      names.push(part1);
    } else {
      const part2 = nameParts2[Math.floor(Math.random() * nameParts2.length)];
      names.push(part2);
    }
  }
  return names;
}


const nigerianNames = generateNigerianNames(1000);

 
  const actions = [
    "just withdrew",
    "just bought a plan",
    "just referred a user",
    "just deposited"
  ];

  // Pick a random name from the list
  function randomName() {
    return nigerianNames[Math.floor(Math.random() * nigerianNames.length)];
  }

  // Show toast and update marquee
  function showRandomToast() {
    const name = randomName();
    const action = actions[Math.floor(Math.random() * actions.length)];
    const msg = `${name} ${action}`;

    // Toast
    document.getElementById("toastMsg").innerText = msg;
    const toastEl = document.getElementById("toastBox");
    const toast = new bootstrap.Toast(toastEl, { delay: 4000 });
    toast.show();

    // Marquee
    const marqueeBox = document.getElementById("marqueeBox");
    marqueeBox.innerHTML += `, 🔔 ${msg} &nbsp;&nbsp;`;
  }

  // Fire immediately on page load
  window.addEventListener("load", showRandomToast);

  // Repeat every 20 seconds (or adjust as needed)
  setInterval(showRandomToast, 40000);
