<?php 
include "includes/session.php";
?>
<!DOCTYPE html>
<html lang="en">


<!-- Mirrored from themes.pixelstrap.net/pwa/mpay/bill.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 25 Aug 2025 22:32:40 GMT -->
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body>
  <!-- header start -->
  <header class="section-t-space">
    <div class="custom-container">
      <div class="header-panel">
        <a href="dashboard" class="back-btn">
          <i class="icon" data-feather="arrow-left"></i>
        </a>
        <h2>Bill pay</h2>
      </div>
    </div>
  </header>
  <!-- header end -->
  <section>
    <div class="custom-container">
     
    
      <div class="row g-3">
        <?php
        $plans = getAllPlans();
        ?>

      <div class="row">
  <?php if (!empty($plans)): ?>
    <?php foreach ($plans as $plan): ?>
      <?php 
        // get powers for this plan
        $powers = getPlanPowers($plan['id']); 
      ?>
      
      <div class="col-md-3 col-6">
        <div class="bill-box">
          <div class="d-flex gap-3">
            <div class="bill-icon">
              <!-- You can make icons dynamic if needed -->
              <img class="img-fluid icon" src="assets/images/svg/9.svg" alt="<?php echo $plan['name']; ?>" />
            </div>
            <div class="bill-details">
              <h5 class="dark-text"><?php echo $plan['name']; ?></h5>
              <h6 class="light-text mt-2">
                <?php echo $plan['description']; ?>
              </h6>
            </div>
          </div>
          <div class="bill-price">
            <h5><?php echo $site['currency']." ".number_format($plan['price'], 2); ?></h5>
            <a href="#pay<?php echo $plan['id']; ?>" data-bs-toggle="modal" class="btn bill-pay bill-paid ">Buy</a>
          </div>
        </div>
      </div>

      
                    <!-- Transaction Detail Modal -->
                    <div class="modal successful-modal transfer-details fade" id="pay<?php echo $plan['id'];?>" tabindex="-1">
                      <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h2 class="modal-title">Plan Details</h2>
                          </div>
                          <div class="modal-body">
                            <ul class="details-list">
                              <li>
                                <h3 class="fw-normal dark-text">Plan</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($plan['name']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Daily Earnings</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($powers[0]['reward']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Referal Bonus</h3>
                                <h3 class="fw-normal light-text"><?php echo $plan['referral_bonus']; ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Power</h3>
                                <h3 class="fw-normal light-text"><?php echo ($powers[0]['min_value']); ?></h3>
                              </li>
                              <li class="amount">
                                <h3 class="fw-normal dark-text">Amount</h3>
                                <h3 class="fw-semibold text-success">
                                  <?php echo $site['currency']." ".number_format($plan['price'], 2); ?>
                                </h3>
                              </li>
                              <li class="d-flex">
                             <button type="button" class="btn btn-primary buy-btn ms-auto" 
                data-id="<?php echo $plan['id']; ?>"
        data-price="<?php echo $plan['price']; ?>"
        data-name="<?php echo $plan['name']; ?>">
          Buy Plan
        </button>  
                            </li>
                            </ul>
                          </div>
                          <button type="button" class="btn close-btn" data-bs-dismiss="modal">
                            <i class="icon" data-feather="x"></i>
                          </button>
                        </div>
                      </div>
                    </div>
                    <!-- End Transaction Detail Modal -->
    <?php endforeach; ?>
  <?php else: ?>
    <p>No plans found.</p>
  <?php endif; ?>
</div>

      </div>
    </div>
    <!-- Toast -->
<!-- Toast -->
<div class="position-fixed top-0 end-0 p-3" style="z-index: 9999">
  <div id="toastBox" class="toast align-items-center text-bg-primary border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body" id="toastMsg">Loading...</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>

 <!-- panel-space start -->
  <section class="panel-space"></section>
  <!-- panel-space end -->

  <!-- bottom navbar start -->
 <?php
 include "includes/tabs.php";
 ?>

  </section>
<script>document.querySelectorAll(".buy-btn").forEach(btn => {
  btn.addEventListener("click", function () {
    let planId = this.getAttribute("data-id");
    let toastEl = document.getElementById("toastBox");
    let toastMsg = document.getElementById("toastMsg");
    let toast = new bootstrap.Toast(toastEl);

    // Show "Processing..."
    toastMsg.innerHTML = "Processing your request...";
    toastEl.classList.remove("text-bg-success", "text-bg-danger");
    toastEl.classList.add("text-bg-primary");
    toast.show();

    // Simulate Ajax call
    fetch("process/buy-plan.php", {
      method: "POST",
      headers: {"Content-Type": "application/x-www-form-urlencoded"},
      body: "plan_id=" + planId
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        toastMsg.innerHTML = "✅ Purchase successful!";
        toastEl.classList.remove("text-bg-primary", "text-bg-danger");
          toastEl.style.top = "20px";
          toastEl.style.right = "20px";
          toastEl.style.zIndex = "9999";
              toastEl.classList.add("text-bg-success");
              toastEl.style.position = "fixed";
  
      } else {
        toastMsg.innerHTML = "❌ Failed: " + data.message;
        toastEl.classList.remove("text-bg-primary", "text-bg-success");
            // Keep toast top-right
    toastEl.style.position = "fixed";
    toastEl.style.top = "20px";
    toastEl.style.right = "20px";
    toastEl.style.zIndex = "9999";
        toastEl.classList.add("text-bg-danger");
     
      }
    })
    .catch(() => {
      toastMsg.innerHTML = "⚠️ Network error!";
      toastEl.classList.remove("text-bg-primary", "text-bg-success");
      toastEl.classList.add("text-bg-danger");
    });
  });
});

</script>




  <!-- swiper js -->
  <script src="assets/js/swiper-bundle.min.js"></script>
  <script src="assets/js/custom-swiper.js"></script>

  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


</html>