<?php 
include "includes/session.php";
?>
<!DOCTYPE html>
<html lang="en">


<!-- Mirrored from themes.pixelstrap.net/pwa/mpay/change-new-password.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 25 Aug 2025 22:33:03 GMT -->
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body>
  <!-- header start -->
  <header class="section-t-space">
    <div class="custom-container">
      <div class="header-panel">
        <a href="profile" class="back-btn">
          <i class="icon" data-feather="arrow-left"></i>
        </a>
        <h2>Change Password</h2>
      </div>
    </div>
  </header>
  <!-- header end -->

  <!-- change password section start -->
  <section>
    <div class="custom-container">
      <form class="auth-form pt-0" id="updatePasswordForm">
        <div class="form-group">
          <label for="inputoldpassword" class="form-label">Old Password</label>
          <input type="password" class="form-control" name="inputoldpassword" placeholder="Enter your old password" />
        </div>

        <div class="form-group">
          <label for="inputnewpassword" class="form-label">New Password</label>
          <input type="password" class="form-control" name="inputnewpassword" placeholder="Enter your new password" />
        </div>

        <div class="form-group">
          <label for="inputconfirmpassword" class="form-label">Confirm Password</label>
          <input type="password" class="form-control" name="inputconfirmpassword"
            placeholder="Enter your confirm password" />
        </div>
      <button type="submit" class="btn theme-btn w-100">Update password</button>

      </form>
    </div>
  </section>
  <!-- change password section start -->



  
    <!-- Toast -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
  <div id="toastBox" class="toast align-items-center text-bg-primary border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body" id="toastMsg">Loading...</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>
<script>

document.getElementById("updatePasswordForm").addEventListener("submit", function(e){
  e.preventDefault();

  let form = this;
  let submitBtn = form.querySelector("button[type=submit]");
  let formData = new FormData(form);

  // Disable button & show processing text
  submitBtn.disabled = true;
  let oldText = submitBtn.innerHTML;
  submitBtn.innerHTML = "Processing...";

  fetch("process/change_password.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.json())
  .then(data => {
    let toastMsg = document.getElementById("toastMsg");
    let toastBoxEl = document.getElementById("toastBox");
    let toastBox = new bootstrap.Toast(toastBoxEl);

    toastMsg.innerText = data.message;

    // Change toast color
    toastBoxEl.classList.remove("text-bg-primary","text-bg-success","text-bg-danger");
    toastBoxEl.classList.add(data.status === "success" ? "text-bg-success" : "text-bg-danger");

    // Keep toast top-right
    toastBoxEl.style.position = "fixed";
    toastBoxEl.style.top = "20px";
    toastBoxEl.style.right = "20px";
    toastBoxEl.style.zIndex = "9999";

    toastBox.show();

    if(data.status === "success"){
      setTimeout(() => {
        window.location.href = "dashboard";
      }, 1500);
    }
  })
  .catch(err => {
    console.error(err);
  })
  .finally(() => {
    // Re-enable button
    submitBtn.disabled = false;
    submitBtn.innerHTML = oldText;
  });
});
</script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


</html>