<?php 
include "includes/session.php";
$userTransactions = getUserTransactions($user_id, $page = 1, $limit = 5);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- iconsax css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/iconsax.css" />


  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body>
 
<!-- nav start -->
 <?php include "includes/nav.php";?>
 <!-- nav end -->

  <!-- card start -->
  <section class="section-b-space">
    <div class="custom-container">
      <div class="card-box">
        <div class="card-details">
          <div class="d-flex justify-content-between">
            <h5 class="fw-semibold">Total Balance</h5>
            <img src="assets/images/svg/ellipse.svg" alt="ellipse" />
          </div>

          <h1 class="mt-2 text-white" >
            <?php echo $site['currency']." ".($userbalance['balance'] + $userbalance['withdrawable_balance']);?>
        </h1>

          <div class="amount-details">
            <div class="amount w-50 text-start">
              <div class="d-flex align-items-center justify-content-start">
                <img class="img-fluid icon" src="assets/images/svg/arrow-down-right.svg" alt="down" />
                <h5>Capital</h5>
              </div>
              <h3 class="text-white">            <?php echo $site['currency']." ".($userbalance['balance']);?></h3>
            </div>
            <div class="amount w-50 text-end border-0">
              <div class="d-flex align-items-center justify-content-end">
                <img class="img-fluid icon" src="assets/images/svg/arrow-up-right.svg" alt="up" />
                <h5>Withdrawable</h5>
              </div>
              <h3 class="text-white">  <?php echo $site['currency']." ".( $userbalance['withdrawable_balance']);?></h3>
            </div>
          </div>
        </div>
        <a href="#add-money" class="add-money theme-color" data-bs-toggle="modal">+ Add Money</a>
      </div>
    </div>
  </section>
  <!-- card end -->

  <!-- categories section starts -->
  <?php include "includes/dashboardActions.php";?>

  <div class=" text-white p-1" style="background-color: #753BE5">
  <marquee id="marqueeBox" behavior="scroll" direction="left">
  mpay is a finance management and earning program with over 2000 active users daily
  </marquee>
</div>
  <!-- categories section end -->

<!-- bill details section starts -->
<?php include "includes/plans.php";?>
<!-- Running plans section starts -->
<!-- Running Plans Section -->
<section>
    <div class="custom-container">
      <div class="title">
        <h2>Running Plans</h2>
        <a href="saving-plans">See all</a>
      </div>
      <div class="row">
        <?php
        // Get user's owned plans and their power activations
        $userId = $_SESSION['user_id']; 
        $ownedPlans = getUserOwnedPlans($userId);
        $activePowers = getUserPowerActivations($userId, 'active');
        
        if (!empty($ownedPlans)):
          foreach ($ownedPlans as $plan):
            // Get plan powers
            $planPowers = getPlanPowers($plan['plan_id']);
            
            // Check if this plan has any active power runs
            $planActivePowers = array_filter($activePowers, function($power) use ($plan) {
                return isset($power['plan_id']) && $power['plan_id'] == $plan['plan_id'];
            });
            
            // Calculate progress
            $progressPercentage = 0;
            $timeLeft = '';
            $statusText = 'Ready to Use';
            $amountEarned = 0;
            $activePower = null;
            
            if (!empty($planActivePowers)) {
                $activePower = reset($planActivePowers);
                
                if (isset($activePower['started_at']) && isset($activePower['end_time'])) {
                    $startTime = strtotime($activePower['started_at']);
                    $endTime = strtotime($activePower['end_time']);
                    $currentTime = time();
                    
                    if ($currentTime < $endTime) {
                        // Still running
                        $totalDuration = $endTime - $startTime;
                        $elapsed = $currentTime - $startTime;
                        $progressPercentage = max(0, min(100, ($elapsed / $totalDuration) * 100));
                        
                        $secondsLeft = $endTime - $currentTime;
                        $hoursLeft = floor($secondsLeft / 3600);
                        $minutesLeft = floor(($secondsLeft % 3600) / 60);
                        $timeLeft = $hoursLeft . 'h ' . $minutesLeft . 'm left';
                        $statusText = 'Running';
                        $amountEarned = $activePower['reward'] ?? 0;
                    } else {
                        // Completed
                        $progressPercentage = 100;
                        $statusText = 'Completed - Ready to Claim';
                        $amountEarned = $activePower['reward'] ?? 0;
                    }
                }
            }
            
            // Progress bar colors
            $progressClass = 'bar1';
            if ($progressPercentage >= 75) $progressClass = 'bar6';
            elseif ($progressPercentage >= 50) $progressClass = 'bar4';
            elseif ($progressPercentage >= 25) $progressClass = 'bar3';
        ?>
        
        <div class="col-lg-4 col-md-6 col-12 mb-3">
          <div class="saving-plan-box">
            <div class="saving-plan-icon">
              <img class="img-fluid" src="assets/images/svg/success-chart.svg" alt="<?php echo htmlspecialchars($plan['name']); ?>" />
            </div>
            <h3><?php echo htmlspecialchars($plan['name']); ?></h3>
            <h6 class="status-text <?php echo $statusText === 'Running' ? 'text-warning' : ($statusText === 'Completed - Ready to Claim' ? 'text-success' : 'text-muted'); ?>">
                <?php echo $statusText; ?>
            </h6>
            
            <?php if (!empty($planActivePowers) && $activePower): ?>
            <!-- Active power run -->
            <div class="progress mb-2" role="progressbar">
              <div class="progress-bar <?php echo $progressClass; ?>" 
                   style="width: <?php echo $progressPercentage; ?>%"></div>
            </div>
            
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h5 class="theme-color">
                <?php echo $site['currency'] . ' ' . number_format($amountEarned, 2); ?>
              </h5>
              <small class="text-muted"><?php echo $timeLeft; ?></small>
            </div>
            
            <?php if ($statusText === 'Completed - Ready to Claim'): ?>
            <button class="btn btn-success btn-sm claim-btn w-100" 
                    data-activation-id="<?php echo $activePower['id']; ?>">
                <span class="btn-text">Claim Reward</span>
                <span class="btn-spinner d-none">
                  <span class="spinner-border spinner-border-sm me-1"></span>
                  Claiming...
                </span>
            </button>
            <?php endif; ?>
            
            <?php else: ?>
            <!-- Available powers -->
            <div class="available-powers mb-2">
              <small class="text-muted">Available Powers:</small>
              <?php if (!empty($planPowers)): ?>
                <?php foreach ($planPowers as $power): ?>
                <div class="power-item d-flex justify-content-between align-items-center p-2 border rounded mt-1">
                  <div>
                    <strong><?php echo htmlspecialchars($power['power_name']); ?></strong>
                    <br><small>Reward: <?php echo $site['currency'] . ' ' . number_format($power['reward'], 2); ?></small>
                    <br><small>Min Value: <?php echo $power['min_value']; ?></small>
                  </div>
                  <button class="btn btn-primary btn-sm activate-power-btn" 
                          data-power-id="<?php echo $power['id']; ?>"
                          data-power-name="<?php echo htmlspecialchars($power['power_name']); ?>">
                      <span class="btn-text">Activate</span>
                      <span class="btn-spinner d-none">
                        <span class="spinner-border spinner-border-sm me-1"></span>
                        Activating...
                      </span>
                  </button>
                </div>
                <?php endforeach; ?>
              <?php else: ?>
                <p class="text-muted">No powers available for this plan.</p>
              <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <div class="d-flex justify-content-between align-items-center mt-2">
              <small class="text-muted">Owned since: <?php echo date('M d, Y', strtotime($plan['purchased_at'])); ?></small>
              <img class="img-fluid arrow" src="assets/images/svg/arrow.svg" alt="arrow" />
            </div>
          </div>
        </div>
        
        <?php 
          endforeach;
        else:
        ?>
        
        <div class="col-12">
          <div class="text-center p-4">
            <img src="assets/images/svg/alert.svg" alt="No Plans" class="mb-3" style="max-width: 150px;">
            <h4 class="text-muted">No Running Plans</h4>
            <p class="text-muted mb-3">You don't have any active plans yet. Purchase a plan to start earning!</p>
            <a href="bill" class="btn btn-primary">Browse Plans</a>
          </div>
        </div>
        
        <?php endif; ?>
      </div>
    </div>
    
    <!-- Toast for notifications -->
    <div class="position-fixed top-0 end-0 p-3" style="z-index: 9999">
      <div id="actionToast" class="toast align-items-center border-0" role="alert">
        <div class="d-flex">
          <div class="toast-body" id="actionToastMsg">Loading...</div>
          <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
      </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle power activation
    document.querySelectorAll('.activate-power-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const powerId = this.getAttribute('data-power-id');
            const powerName = this.getAttribute('data-power-name');
            
            // Show loading state
            const btnText = this.querySelector('.btn-text');
            const btnSpinner = this.querySelector('.btn-spinner');
            
            this.disabled = true;
            btnText.classList.add('d-none');
            btnSpinner.classList.remove('d-none');
            
            fetch('process/activate-power.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ power_id: powerId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.status === 'success') {
                    showToast('Power activated successfully!', 'success');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    showToast(data.message || 'Failed to activate power', 'danger');
                    // Reset button
                    this.disabled = false;
                    btnText.classList.remove('d-none');
                    btnSpinner.classList.add('d-none');
                }
            })
            .catch(() => {
                showToast('Network error occurred', 'danger');
                // Reset button
                this.disabled = false;
                btnText.classList.remove('d-none');
                btnSpinner.classList.add('d-none');
            });
        });
    });
    
    // Handle reward claiming
    document.querySelectorAll('.claim-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const activationId = this.getAttribute('data-activation-id');
            
            // Show loading state
            const btnText = this.querySelector('.btn-text');
            const btnSpinner = this.querySelector('.btn-spinner');
            
            this.disabled = true;
            btnText.classList.add('d-none');
            btnSpinner.classList.remove('d-none');
            
            fetch('process/claim-reward.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ activation_id: activationId })
            })
            .then(res => res.json())
            .then(data => {
                if (data.status === 'success') {
                    showToast('Reward claimed successfully!', 'success');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    showToast(data.message || 'Failed to claim reward', 'danger');
                    // Reset button
                    this.disabled = false;
                    btnText.classList.remove('d-none');
                    btnSpinner.classList.add('d-none');
                }
            })
            .catch(() => {
                showToast('Network error occurred', 'danger');
                // Reset button
                this.disabled = false;
                btnText.classList.remove('d-none');
                btnSpinner.classList.add('d-none');
            });
        });
    });
    
    // Auto-refresh every 30 seconds if there are active powers
    setInterval(function() {
        const activeProgressBars = document.querySelectorAll('.progress-bar');
        if (activeProgressBars.length > 0) {
            location.reload();
        }
    }, 19000000);
});

function showToast(message, type) {
    const toastEl = document.getElementById('actionToast');
    const toastMsg = document.getElementById('actionToastMsg');
    
    toastMsg.innerHTML = message;
    toastEl.className = `toast align-items-center text-bg-${type} border-0`;
    
    const toast = new bootstrap.Toast(toastEl);
    toast.show();
}
</script>

<style>
.saving-plan-box {
    transition: transform 0.2s, box-shadow 0.2s;
    border: 1px solid #e9ecef;
    border-radius: 10px;
    padding: 1.5rem;
    background: white;
}

.saving-plan-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.status-text {
    font-weight: 500;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.power-item {
    background: #f8f9fa;
    border: 1px solid #dee2e6 !important;
    margin-bottom: 0.5rem;
}

.progress {
    height: 8px;
    background: #e9ecef;
    border-radius: 10px;
    overflow: hidden;
}

.progress-bar {
    transition: width 0.3s ease;
    border-radius: 10px;
}

.bar1 { background: linear-gradient(90deg, #ff6b6b, #ee5a52); }
.bar3 { background: linear-gradient(90deg, #feca57, #ff9ff3); }
.bar4 { background: linear-gradient(90deg, #48dbfb, #0abde3); }
.bar6 { background: linear-gradient(90deg, #1dd1a1, #10ac84); }

.claim-btn {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); }
    70% { box-shadow: 0 0 0 10px rgba(40, 167, 69, 0); }
    100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); }
}

.btn:disabled {
    opacity: 0.7;
    cursor: not-allowed;
}

.btn-spinner {
    display: flex;
    align-items: center;
    justify-content: center;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
}
</style>
<!-- running plans section end -->


<style>
.saving-plan-box {
    transition: transform 0.2s, box-shadow 0.2s;
}

.saving-plan-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.status-text {
    font-weight: 500;
    font-size: 0.9rem;
}

.power-item {
    background: #f8f9fa;
    border: 1px solid #dee2e6 !important;
}

.progress {
    height: 8px;
    background: #e9ecef;
    border-radius: 10px;
    overflow: hidden;
}

.progress-bar {
    transition: width 0.3s ease;
    border-radius: 10px;
}

.bar1 { background: linear-gradient(90deg, #ff6b6b, #ee5a52); }
.bar3 { background: linear-gradient(90deg, #feca57, #ff9ff3); }
.bar4 { background: linear-gradient(90deg, #48dbfb, #0abde3); }
.bar6 { background: linear-gradient(90deg, #1dd1a1, #10ac84); }

.claim-btn {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); }
    70% { box-shadow: 0 0 0 10px rgba(40, 167, 69, 0); }
    100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); }
}

.btn:disabled {
    opacity: 0.7;
    cursor: not-allowed;
}

.spinner-border-sm {
    width: 1rem;
    height: 1rem;
}
</style>

  <!-- quick send section starts -->
<section>
  <div class="custom-container">
    <div class="title">
      <h2>My Referrals</h2>
      <a href="my-referrals">See all</a>
    </div>
  </div>

  <?php
  $referrals = getUserReferrals($user_id, $page = 1, $limit = 5);

  // Debugging output (remove later)
  // print_r($referrals);
  ?>

  <div class="quick-send">
  

    <?php if (!empty($referrals['referrals'])): ?>
      <?php foreach ($referrals['referrals'] as $ref): ?>
        <?php
          // Generate initials from fullname
          $nameParts = explode(" ", $ref['fullname']);
          $initials = strtoupper(substr($nameParts[0], 0, 1) . (isset($nameParts[1]) ? substr($nameParts[1], 0, 1) : ""));
        ?>
        <div class="profile" style="padding: 20px">
          <a href="javascript:void(0)">
            <div class="new-image" style="width:40px;height:40px;border-radius:50%;background:#007bff;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:bold;font-size:13px;">
              <?php echo $initials; ?>
            </div>
            <h6 style="font-size: 13px text-align: center; margin-left: 10px"><?php echo htmlspecialchars($ref['fullname']); ?></h6>
          </a>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p>No referrals yet.</p>
    <?php endif; ?>
  </div>
</section>

  <!-- quick send section end -->


  <!-- bill details section starts -->
  <!-- Transaction section starts -->
  <section>
    <div class="custom-container">
      <div class="title">
        <h2>Transaction</h2>
        <a href="transaction-history">See all</a>
      </div>

      <div class="row gy-3">
  <?php if (!empty($userTransactions['transactions'])): ?>
    <?php foreach ($userTransactions['transactions'] as $transaction): ?>
        <div class="col-12">
            <div class="transaction-box">
                <a href="#transaction-detail<?php echo $transaction['id'];?>" data-bs-toggle="modal"  class="d-flex gap-3">
                    <div class="transaction-image">
                        <?php 
                            // Feather icons mapping
                            $iconMap = [
                                'deposit'     => 'log-in',      // deposit icon
                                'purchase'    => 'shopping-cart',
                                'referral'    => 'user-plus',
                                'activation'  => 'key',
                                'withdrawal'  => 'log-out',
                                'adjustment'  => 'settings',
                            ];
                            $icon = isset($iconMap[$transaction['type']]) ? $iconMap[$transaction['type']] : 'circle';
                        ?>
                        <i class="categories-icon icon1" data-feather="<?php echo $icon; ?>"></i>
                    </div>

                    <div class="transaction-details">
                        <div class="transaction-name">
                            <h5><?php echo ucfirst($transaction['type']); ?></h5>
                            <?php 
                                // Decide color class
                                $colorClass = 'success-color';
                                if ($transaction['type'] == 'withdrawal') {
                                    $colorClass = 'error-color';
                                } elseif ($transaction['type'] == 'purchase') {
                                    $colorClass = 'warning-color';
                                }
                            ?>
                            <h3 class="<?php echo $colorClass; ?>">
                                <?php echo $site['currency']." ". number_format($transaction['amount'], 2); ?>
                            </h3>
                        </div>

                        <div class="d-flex justify-content-between">
                            <h5 class="light-text"><?php echo ucfirst($transaction['status']); ?></h5>
                            <h5 class="light-text">
                                <?php echo date("h:i a", strtotime($transaction['created_at'])); ?>
                            </h5>
                        </div>
                    </div>
                </a>
            </div>
        </div>
          <!-- Transaction Detail Modal -->
                    <div class="modal successful-modal transfer-details fade" id="transaction-detail<?php echo $transaction['id'];?>" tabindex="-1">
                      <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h2 class="modal-title">Transaction Detail</h2>
                          </div>
                          <div class="modal-body">
                            <ul class="details-list">
                              <li>
                                <h3 class="fw-normal dark-text">Status</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($transaction['status']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Transaction category</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($transaction['type']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Reference</h3>
                                <h3 class="fw-normal light-text"><?php echo $transaction['reference']; ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Date</h3>
                                <h3 class="fw-normal light-text"><?php echo date("d M, Y h:i a", strtotime($transaction['created_at'])); ?></h3>
                              </li>
                              <li class="amount">
                                <h3 class="fw-normal dark-text">Amount</h3>
                                <h3 class="fw-semibold <?php echo $colorClass; ?>">
                                  <?php echo $site['currency']." ".number_format($transaction['amount'], 2); ?>
                                </h3>
                              </li>
                            </ul>
                          </div>
                          <button type="button" class="btn close-btn" data-bs-dismiss="modal">
                            <i class="icon" data-feather="x"></i>
                          </button>
                        </div>
                      </div>
                    </div>
                    <!-- End Transaction Detail Modal -->
    <?php endforeach; ?>
<?php else: ?>
    <p>No transactions found.</p>
<?php endif; ?>


      </div>
    </div>
  </section>
  <!-- Transaction section end -->


  <!-- monthly statistics section starts -->
  <section>
    <div class="custom-container">
      <div class="statistics-banner">
        <div class="d-flex justify-content-center gap-3">
          <div class="statistics-image">
            <i class="icon" data-feather="bar-chart-2"></i>
          </div>
          <div class="statistics-content d-block">
            <h5>Monthly Statistics</h5>
            <h6>30% better performance than previous spendings</h6>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- monthly statistics section end -->

  <!-- news-update section starts --
  <section class="section-b-space">
    <div class="custom-container">
      <div class="title">
        <h2>News Update</h2>
        <a href="news-update.html">See all</a>
      </div>
      <div class="row gy-3">
        <div class="col-12">
          <div class="news-update-box">
            <div class="d-flex align-items-center gap-3">
              <a href="news-update-details.html">
                <img class="img-fluid news-update-image" src="assets/images/1.jpg" alt="img1" />
              </a>
              <div class="news-update-content">
                <a href="news-update-details.html">
                  <h3>Save and invest to obtain more</h3>
                </a>
                <div class="news-writer">
                  <h6>13 May, 23</h6>
                  <h6>-Smith</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12">
          <div class="news-update-box">
            <div class="d-flex align-items-center gap-3">
              <a href="news-update-details.html">
                <img class="img-fluid news-update-image" src="assets/images/2.jpg" alt="img2" />
              </a>
              <div class="news-update-content">
                <a href="news-update-details.html">
                  <h3>How to get more money from savings</h3>
                </a>
                <div class="news-writer">
                  <h6>10 May, 23</h6>
                  <h6>-Laila</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12">
          <div class="news-update-box">
            <div class="d-flex align-items-center gap-3">
              <a href="news-update-details.html">
                <img class="img-fluid news-update-image" src="assets/images/3.jpg" alt="img3" />
              </a>
              <div class="news-update-content">
                <a href="news-update-details.html">
                  <h3>5 Tips on expand your business</h3>
                </a>
                <div class="news-writer">
                  <h6>6 May, 23</h6>
                  <h6>-Brunt</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <- news-update section end -->

  <!-- panel-space start -->
  <section class="panel-space"></section>
  <!-- panel-space end -->

  <!-- bottom navbar start -->
 <?php
 include "includes/tabs.php";
 ?>
  <!-- bottom navbar end -->

  <!-- add money modal start -->
 <?php
 include "includes/forms/addMoney.php";
 ?>
  <!-- add money modal end -->

  <!-- Toast Container -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
  <div id="toastBox" class="toast align-items-center text-bg-primary border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body" id="toastMsg">Loading...</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>

<script src="./assets/js/names.js"></script>
  

  <!-- pwa install app popup start -->
  <div class="offcanvas offcanvas-bottom addtohome-popup theme-offcanvas" tabindex="-1" id="offcanvas">
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    <div class="offcanvas-body small">
      <div class="app-info">
        <img src="assets/images/logo/48.png" class="img-fluid" alt="" />
        <div class="content">
          <h4>mPay App</h4>
          <a href="#">www.mPay-app.com</a>
        </div>
      </div>
      <a href="#!" class="btn theme-btn install-app btn-inline home-screen-btn m-0" id="installapp">Add to Home
        Screen</a>
    </div>
  </div>
  <!-- pwa install app popup start -->

  <!-- swiper js -->
  <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <script src="assets/js/custom-swiper.js"></script>
  <script src="https://js.paystack.co/v2/inline.js"></script>

  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- iconsax js -->
  <script src="assets/js/iconsax.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- homescreen popup js -->
  <script src="assets/js/homescreen-popup.js"></script>

  <!-- PWA offcanvas popup js -->
  <script src="assets/js/offcanvas-popup.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


</html>