<?php
require_once "functions.php"; // file where approveDeposit() is defined

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $reference = trim($_POST['reference']);

    if (!empty($reference)) {
        // Fetch transaction_id using reference
        $stmt = $conn->prepare("SELECT id FROM transactions WHERE reference = ? AND type = 'deposit'");
        $stmt->bind_param("s", $reference);
        $stmt->execute();
        $res = $stmt->get_result()->fetch_assoc();

        if ($res) {
            $transaction_id = $res['id'];
            $response = approveDeposit($transaction_id);
            $message = $response['message'];
        } else {
            $message = "Transaction with reference '$reference' not found.";
        }
    } else {
        $message = "Please enter a reference.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Approve Deposit</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="card shadow p-4">
        <h3 class="mb-3">Approve Deposit</h3>

        <?php if (!empty($message)): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="mb-3">
                <label for="reference" class="form-label">Deposit Reference</label>
                <input type="text" class="form-control" id="reference" name="reference" placeholder="Enter deposit reference">
            </div>
            <button type="submit" class="btn btn-primary">Approve</button>
        </form>
    </div>
</div>
</body>
</html>
