<!-- add money modal start -->
<div class="modal add-money-modal fade" id="add-money" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content rounded-3 shadow-lg">
      <div class="modal-header border-0">
        <h2 class="modal-title fw-bold">Add Money</h2>
      </div>
      <div class="modal-body">

        <!-- Instructions -->
        <p class="text-muted small mb-3">
          Please transfer the amount to the bank account below. After making payment, click <b>Proceed</b> to generate your reference and confirm on WhatsApp.
        </p>

        <!-- Bank Details -->
    <div class="card border p-3 mb-3 rounded-3 bg-light">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <span class="fw-semibold text-dark">Bank Name:</span>
    <span class="text-primary"><?= $site['bank']; ?></span>
  </div>
  <div class="d-flex justify-content-between align-items-center mb-2">
    <span class="fw-semibold text-dark">Account:</span>
    <span class="text-primary"><?= $site['account_name']; ?></span>
  </div>
  <div class="d-flex justify-content-between align-items-center">
    <span class="fw-semibold text-dark">Account Number:</span>
    <div class="d-flex align-items-center">
      <span id="accountNumber" class="me-2 text-primary fw-bold"><?= $site['account_number']; ?></span>
      <button class="btn btn-sm btn-outline-secondary d-flex align-items-center justify-content-center" 
              id="copyAccountBtn" title="Copy Account Number" style="width:34px;height:34px;">
        <i data-feather="copy" data-account="<?= $site['account_number']; ?>" ></i>
      </button>
    </div>
  </div>
</div>

        <!-- Amount Input -->
        <div class="form-group mt-3">
          <label for="inputamount" class="form-label fw-semibold mb-2">Amount (₦)</label>
          <input type="number" class="form-control form-control-lg" id="inputamount" placeholder="Enter amount" />
        </div>

        <!-- Proceed Button -->
        <button id="depositBtn" class="btn theme-btn w-100 mt-4 rounded-pill">
          <span class="btn-text">Proceed</span>
          <span class="btn-spinner d-none">
            <span class="spinner-border spinner-border-sm me-2" role="status"></span>
            Processing...
          </span>
        </button>
      </div>

      <!-- Close Button -->
      <button type="button" class="btn close-btn" data-bs-dismiss="modal">
        <i class="icon" data-feather="x"></i>
      </button>
    </div>
  </div>
</div>
<!-- add money modal end -->

<script>
document.getElementById("depositBtn").addEventListener("click", function() {
  let amount = document.getElementById("inputamount").value.trim();
  let btn = document.getElementById("depositBtn");

  if (!amount || amount <= 0) {
    showToast("Please enter a valid amount", "error");
    return;
  }

  function setButtonState(processing) {
    if (processing) {
      btn.disabled = true;
      btn.querySelector('.btn-text').classList.add('d-none');
      btn.querySelector('.btn-spinner').classList.remove('d-none');
    } else {
      btn.disabled = false;
      btn.querySelector('.btn-text').classList.remove('d-none');
      btn.querySelector('.btn-spinner').classList.add('d-none');
    }
  }

  setButtonState(true);

  let reference = "DEP-" + Date.now();

  $.ajax({
    url: "process/request_deposit.php",
    type: "POST",
    dataType: "json",
    data: {
      reference: reference,
      amount: amount
    },
    success: function(data) {
      setButtonState(false);
      showToast(data.message, data.status);

      if (data.status === "success") {
        let whatsappNumber = "<?= preg_replace('/[^0-9]/', '', $site['site_phone']); ?>";
        let bankName = "<?= $site['bank']; ?>";
        let accountNumber = "<?= $site['account_number']; ?>";

        let msg = `Hello, I have made a deposit.\n\nReference: ${reference}\nAmount: ₦${amount}\nBank: ${bankName}\nAccount: ${accountNumber}`;
        let whatsappURL = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(msg)}`;

        window.open(whatsappURL, "_blank");
        setTimeout(() => location.reload(), 2000);
      }
    },
    error: function(xhr, status, error) {
      setButtonState(false);
      showToast("Deposit request failed!", "error");
    },
    timeout: 10000
  });
});

document.getElementById("copyAccountBtn").addEventListener("click", function() {
  let accNum = this.getAttribute("data-account");
  navigator.clipboard.writeText(accNum).then(() => {
    showToast("Account number copied!", "success");
  }).catch(() => {
    showToast("Failed to copy account number", "error");
  });
});


// Re-render feather icons (important if content is added dynamically)
if (typeof feather !== "undefined") {
  feather.replace();
}
// Toast Notification
function showToast(msg, type) {
  let bg = type === "success" ? "#28a745" : "#dc3545";
  let toast = document.createElement("div");
  toast.style.cssText = `
    position: fixed;
    top: 20px;
    right: 20px;
    background: ${bg};
    color: #fff;
    padding: 12px 20px;
    border-radius: 6px;
    z-index: 9999;
    font-family: Arial, sans-serif;
    font-size: 14px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    max-width: 300px;
    word-wrap: break-word;
  `;
  toast.innerText = msg;
  document.body.appendChild(toast);

  toast.style.opacity = '0';
  toast.style.transition = 'opacity 0.3s ease-in';
  setTimeout(() => { toast.style.opacity = '1'; }, 10);

  setTimeout(() => { 
    toast.style.opacity = '0';
    setTimeout(() => { toast.remove(); }, 300);
  }, 3000);
}
</script>
