<?php
// Get the current page name from the URL
$current_page = basename($_SERVER['REQUEST_URI'], '');

// Remove any query parameters
$current_page = strtok($current_page, '?');

// Function to check if the current page matches the menu item
function isActive($page) {
    global $current_page;
    return $current_page === $page ? 'active' : '';
}
?>

<div class="navbar-menu">
    <div class="scanner-bg">
      <a href="my-referrals" class="scanner-btn">
        <img class="img-fluid" src="assets/images/svg/scan.svg" alt="scan" />
      </a>
    </div>
    <ul>
      <li class="<?php echo isActive('dashboard'); ?>">
        <a href="dashboard">
          <div class="icon">
            <img class="unactive" src="assets/images/svg/mpay.svg" alt="mPay" />
            <img class="active" src="assets/images/svg/mpay-fill.svg" alt="mPay" />
          </div>
          <h5 class="<?php echo isActive('dashboard'); ?>">Dashboard</h5>
        </a>
      </li>

      <li class="<?php echo isActive('bill'); ?>">
        <a href="bill">
          <div class="icon">
            <img class="unactive" src="assets/images/svg/9.svg" alt="categories" />
            <img class="active" src="assets/images/svg/9.svg" alt="categories" />
          </div>
          <h5>Plans</h5>
        </a>
      </li>

      <li></li>

      <li class="<?php echo isActive('transaction-history'); ?>">
        <a href="transaction-history">
          <div class="icon">
            <img class="unactive" src="assets/images/svg/bar-chart.svg" alt="bag" />
            <img class="active" src="assets/images/svg/bar-chart-fill.svg" alt="bag" />
          </div>
          <h5>Transactions</h5>
        </a>
      </li>

      <li class="<?php echo isActive('profile'); ?>">
        <a href="profile">
          <div class="icon">
            <img class="unactive" src="assets/images/svg/user.svg" alt="profile" />
            <img class="active" src="assets/images/svg/user-fill.svg" alt="profile" />
          </div>
          <h5>Profile</h5>
        </a>
      </li>
    </ul>
</div>