<?php
// Start session
session_start();

// Unset all session variables
$_SESSION = array();

// If it's desired to kill the session, also delete the session cookie.
// Note: This will destroy the session, and not just the session data!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Clear any additional cookies that might be set (optional)
// Uncomment and modify these lines if you have other cookies to clear
/*
setcookie('remember_me', '', time() - 3600, '/');
setcookie('user_token', '', time() - 3600, '/');
setcookie('auth_token', '', time() - 3600, '/');
*/

// Prevent caching
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Redirect to signin page
header("Location: signin");
exit();
?>