<?php 
include "includes/session.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobmoney
  <meta name=" apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body>
        
<!-- quick send section starts -->
<section>
  <?php 
  
  // Generate referral link
  $site_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
  $referral_link = $site_url . "/signup?ref=" . $user['referral_code'];
  ?>
  
  <div class="custom-container">
    <div class="title">
      <h2>My Referrals</h2>
    </div>
  </div>

  <!-- Referral Link Section -->
  <div class="custom-container" style="margin-bottom: 20px;">
    <div class="referral-section" style="background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 20px;">
      <h4 style="margin-bottom: 15px; color: #333;">Your Referral Link</h4>
      
      <!-- Referral Link Display -->
      <div style="display: flex; align-items: center; margin-bottom: 15px; background: white; padding: 10px; border-radius: 8px; border: 1px solid #ddd;">
        <input type="text" id="referralLink" value="<?php echo htmlspecialchars($referral_link); ?>" 
               style="flex: 1; border: none; outline: none; font-size: 14px; color: #666;" readonly>
        <button onclick="copyReferralLink()" style="background: #007bff; color: white; border: none; padding: 8px 12px; border-radius: 5px; margin-left: 10px; cursor: pointer;">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect>
            <path d="m5 15-2-2v-8a2 2 0 0 1 2-2h8"></path>
          </svg>
        </button>
        <button onclick="shareReferralLink()" style="background: #25D366; color: white; border: none; padding: 8px 12px; border-radius: 5px; margin-left: 5px; cursor: pointer;">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="m22 2-7 20-4-9-9-4Z"></path>
            <path d="M22 2 11 13"></path>
          </svg>
        </button>
      </div>

      <!-- QR Code Section -->
      <div style="text-align: center;">
        <button onclick="generateQRCode()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; margin-bottom: 15px;">
          Generate QR Code
        </button>
        <div id="qrCodeContainer" style="display: none;">
          <canvas id="qrCanvas" style="border: 1px solid #ddd; border-radius: 5px;"></canvas>
          <p style="font-size: 12px; color: #666; margin-top: 10px;">Scan to join using your referral link</p>
        </div>
      </div>
    </div>
  </div>

  <?php
  $referrals = getUserReferrals($user_id, $page = 1, $limit = 50);
  ?>

  <div class="quick-send">
    <?php if (!empty($referrals['referrals'])): ?>
      <?php foreach ($referrals['referrals'] as $ref): ?>
        <?php
          // Generate initials from fullname
          $nameParts = explode(" ", $ref['fullname']);
          $initials = strtoupper(substr($nameParts[0], 0, 1) . (isset($nameParts[1]) ? substr($nameParts[1], 0, 1) : ""));
        ?>
        <div class="profile" style="margin: 30px">
          <a href="javascript:void(0)">
            <div class="new-image" style="width:40px;height:40px;border-radius:50%;background:#007bff;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:bold;font-size:13px;">
              <?php echo $initials; ?>
            </div>
            <h6 style="font-size: 13px "><?php echo htmlspecialchars($ref['fullname']); ?></h6>
          </a>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <p>No referrals yet.</p>
    <?php endif; ?>
  </div>

  <!-- panel-space start -->
  <section class="panel-space"></section>
  <!-- panel-space end -->

  <!-- bottom navbar start -->
  <?php
  include "includes/tabs.php";
  ?>
</section>

<!-- Toast notification -->
<div id="toast" style="position: fixed; top: 20px; right: 20px; background: #28a745; color: white; padding: 10px 20px; border-radius: 5px; display: none; z-index: 1000;">
  Link copied to clipboard!
</div>

<script>
// QR Code generation function
function generateQRCode() {
    const canvas = document.getElementById('qrCanvas');
    const ctx = canvas.getContext('2d');
    const referralLink = document.getElementById('referralLink').value;
    
    // Set canvas size
    canvas.width = 200;
    canvas.height = 200;
    
    // Simple QR code generation using Google Charts API
    const qrCodeUrl = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodeURIComponent(referralLink)}`;
    
    const img = new Image();
    img.onload = function() {
        ctx.drawImage(img, 0, 0, 200, 200);
        document.getElementById('qrCodeContainer').style.display = 'block';
    };
    img.src = qrCodeUrl;
}

// Copy referral link function
function copyReferralLink() {
    const referralLink = document.getElementById('referralLink');
    referralLink.select();
    referralLink.setSelectionRange(0, 99999); // For mobile devices
    
    try {
        document.execCommand('copy');
        showToast('Link copied to clipboard!');
    } catch (err) {
        // Fallback for modern browsers
        navigator.clipboard.writeText(referralLink.value).then(function() {
            showToast('Link copied to clipboard!');
        }).catch(function() {
            showToast('Failed to copy link');
        });
    }
}

// Share referral link function
function shareReferralLink() {
    const referralLink = document.getElementById('referralLink').value;
    const message = `Join me on this amazing platform! Use my referral link: ${referralLink}`;
    
    // Check if Web Share API is supported
    if (navigator.share) {
        navigator.share({
            title: 'Join me!',
            text: message,
            url: referralLink
        }).catch(console.error);
    } else {
        // Fallback to WhatsApp
        const whatsappUrl = `https://wa.me/?text=${encodeURIComponent(message)}`;
        window.open(whatsappUrl, '_blank');
    }
}

// Show toast notification
function showToast(message) {
    const toast = document.getElementById('toast');
    toast.textContent = message;
    toast.style.display = 'block';
    
    setTimeout(() => {
        toast.style.display = 'none';
    }, 3000);
}

// Auto-generate QR code on page load
document.addEventListener('DOMContentLoaded', function() {
    generateQRCode();
});
</script>

<style>
.referral-section button:hover {
    opacity: 0.9;
    transform: translateY(-1px);
    transition: all 0.2s ease;
}

.referral-section svg {
    width: 16px;
    height: 16px;
}

#toast {
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

@media (max-width: 768px) {
    .referral-section {
        padding: 15px !important;
    }
    
    .referral-section input {
        font-size: 12px !important;
    }
    
    #qrCanvas {
        max-width: 150px;
        height: auto;
    }
}
</style>



  

  <!-- swiper js -->
  <script src="assets/js/swiper-bundle.min.js"></script>
  <script src="assets/js/custom-swiper.js"></script>

  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>
</html>