<?php
session_start();
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "Please login first"]);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$powerId = $input['power_id'] ?? null;

if (!$powerId) {
    echo json_encode(["status" => "error", "message" => "Invalid power ID"]);
    exit;
}

$result = activatePower($_SESSION['user_id'], $powerId);
echo json_encode($result);
?>