<?php
session_start();
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "Please login first"]);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$activationId = $input['activation_id'] ?? null;

if (!$activationId) {
    echo json_encode(["status" => "error", "message" => "Invalid activation ID"]);
    exit;
}

$result = completePowerRun($activationId);
echo json_encode($result);
?>