<?php 
include "includes/functions.php";

if(isset($_GET['ref'])){
$ref =   $_GET['ref'];
}else{
$ref = "";
}
  ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body class="auth-body">
  <!-- header starts -->
  <div class="auth-header">
    <a href="./"> <i class="back-btn" data-feather="arrow-left"></i> </a>

    <img class="img-fluid img" src="assets/images/authentication/1.svg" alt="v1" />

    <div class="auth-content">
      <div>
        <h2>Welcome back !!</h2>
        <h4 class="p-0">Fill up the form</h4>
      </div>
    </div>
  </div>
  <!-- header end -->

 <!-- Login Section -->
<form class="auth-form" id="loginForm">
  <div class="custom-container">
    <div class="form-group">
      <label for="inputusername" class="form-label">Phone Number</label>
      <div class="form-input">
        <input type="text" class="form-control" id="inputusername" name="phone" placeholder="Enter Your Phone Number" required />
      </div>
    </div>

    <div class="form-group">
      <label for="inputpin" class="form-label">Pin</label>
      <div class="form-input">
        <input type="password" class="form-control" id="inputpin" name="pin" placeholder="Enter Your pin" required />
      </div>
    </div>

    <div class="remember-option mt-3">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" id="flexCheckDefault" />
        <label class="form-check-label" for="flexCheckDefault">Remember me</label>
      </div>
      <a class="forgot" href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $site['site_phone']);?>?text=Hello%2C%20I%20forgot%20my%20password" target="_blank">Forgot Pin?</a>
    </div>

    <button type="submit" class="btn theme-btn w-100">Sign In</button>
    <h4 class="signup">Don’t have an account ?<a href="signup"> Sign up</a></h4>
  </div>
</form>

<!-- Toast -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
  <div id="toastBox" class="toast align-items-center text-bg-primary border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body" id="toastMsg">Loading...</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>
<script>
document.getElementById("loginForm").addEventListener("submit", function(e){
  e.preventDefault();

  let form = this;
  let submitBtn = form.querySelector("button[type=submit]");
  let formData = new FormData(form);

  // Disable button & show processing text
  submitBtn.disabled = true;
  let oldText = submitBtn.innerHTML;
  submitBtn.innerHTML = "Processing...";

  fetch("process/login.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.json())
  .then(data => {
    let toastMsg = document.getElementById("toastMsg");
    let toastBoxEl = document.getElementById("toastBox");
    let toastBox = new bootstrap.Toast(toastBoxEl);

    toastMsg.innerText = data.message;

    // Change toast color
    toastBoxEl.classList.remove("text-bg-primary","text-bg-success","text-bg-danger");
    toastBoxEl.classList.add(data.status === "success" ? "text-bg-success" : "text-bg-danger");

    // Keep toast top-right
    toastBoxEl.style.position = "fixed";
    toastBoxEl.style.top = "20px";
    toastBoxEl.style.right = "20px";
    toastBoxEl.style.zIndex = "9999";

    toastBox.show();

    if(data.status === "success"){
      setTimeout(() => {
        window.location.href = "dashboard";
      }, 1500);
    }
  })
  .catch(err => {
    console.error(err);
  })
  .finally(() => {
    // Re-enable button
    submitBtn.disabled = false;
    submitBtn.innerHTML = oldText;
  });
});
</script>


  <!-- login section start -->

  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


</html>