<?php 
include "includes/functions.php";

if(isset($_GET['ref'])){
$ref =   $_GET['ref'];
}else{
$ref = "";
}
  ?>
<!DOCTYPE html>
<html lang="en">


<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body class="auth-body">
  <!-- header starts -->
  <div class="auth-header">
    <a href="signin"> <i class="back-btn" data-feather="arrow-left"></i> </a>

    <img class="img-fluid img" src="assets/images/authentication/6.svg" alt="v1" />

    <div class="auth-content">
      <div>
        <h2>Welcome back !!</h2>
        <h4 class="p-0">Fill up the form</h4>
      </div>
    </div>
  </div>
  <!-- header end -->

  <!-- login section start -->
  <form class="auth-form" target="_blank">
    <div class="custom-container">
      <div class="form-group">
        <label for="inputname" class="form-label">Full name</label>
        <div class="form-input">
          <input type="text" class="form-control" id="inputname" placeholder="Enter your name" />
        </div>
      </div>

      <div class="form-group">
        <label for="inputusername" class="form-label">Email</label>
        <div class="form-input">
          <input type="email" class="form-control" id="inputusername" placeholder="Enter Your Email" />
        </div>
      </div>
      <div class="form-group">
        <label for="inputusername" class="form-label">Phone Number</label>
        <div class="form-input">
          <input type="tel" class="form-control" id="inputphone" placeholder="Enter Your Phone number" />
        </div>
      </div>
      <div class="form-group">
        <label for="inputusername" class="form-label">Referral <span class="text-muted">(optional)</span></label>
        <div class="form-input">
          <input type="text" class="form-control" id="inputref" placeholder="Enter Your referral code" value="<?php echo $ref;?>" />
        </div>
      </div>

      <div class="form-group">
        <label for="newpin" class="form-label">Enter new pin</label>
        <div class="form-input">
          <input type="number" class="form-control" id="newpin" placeholder="Enter pin" />
        </div>
      </div>

      <div class="form-group">
        <label for="confirmpin" class="form-label">Re-enter new pin</label>
        <div class="form-input">
          <input type="number" class="form-control" id="confirmpin" placeholder="Re-enter pin" />
        </div>
      </div>
      <div class="remember-option mt-3">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault" />
          <label class="form-check-label" for="flexCheckDefault">I agree to all terms & condition</label>
        </div>
      </div>

      <a href="#" class="btn theme-btn w-100">Sign up</a>
      <h4 class="signup">Already have an account ?<a href="signin"> Sign in</a></h4>
    </div>
  </form>
  <!-- login section start -->

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(".theme-btn").on("click", function (e) {
  e.preventDefault();

  let btn = $(this); // reference to the button

  let fullname   = $("#inputname").val().trim();
  let email      = $("#inputusername").val().trim();
  let phone      = $("#inputphone").val().trim();
  let referral   = $("#inputref").val().trim();
  let pin        = $("#newpin").val().trim();
  let confirmpin = $("#confirmpin").val().trim();
  let terms      = $("#flexCheckDefault").is(":checked");

  if (!fullname || !email || !pin || !confirmpin || !phone) {
    showToast("All fields are required", "error");
    return;
  }
  if (pin !== confirmpin) {
    showToast("Pins do not match", "error");
    return;
  }
  if (!terms) {
    showToast("Please accept terms & conditions", "error");
    return;
  }

  // disable button and show loading text
  btn.prop("disabled", true).text("Processing...");

  $.ajax({
    url: "process/register.php",
    type: "POST",
    data: { fullname, email, pin, phone, referral },
    dataType: "json",
    success: function (res) {
      if (res.status === "success") {
        showToast(res.message, "success");
        setTimeout(() => { window.location.href = "signin"; }, 2000);
      } else {
        showToast(res.message, "error");
      }
    },
    error: function () {
      showToast("Something went wrong!", "error");
    },
    complete: function () {
      // enable button back and reset text
      btn.prop("disabled", false).text("Register");
    }
  });
});

function showToast(msg, type) {
  let bg = type === "success" ? "green" : "red";
  let toast = $(`<div style="
      position:fixed;top:20px;right:20px;
      background:${bg};color:#fff;padding:10px 20px;
      border-radius:6px;z-index:9999;">${msg}</div>`);
  $("body").append(toast);
  setTimeout(() => { toast.fadeOut(400, () => toast.remove()); }, 3000);
}
</script>


  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


</html>