<?php 
include "includes/session.php";
$userTransactions = getUserTransactions($user_id, $page = 1, $limit = 50);
?>
<!DOCTYPE html>
<html lang="en">


<!-- Mirrored from themes.pixelstrap.net/pwa/mpay/transaction-history.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 25 Aug 2025 22:32:42 GMT -->
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="mpay" />
  <meta name="keywords" content="mpay" />
  <meta name="author" content="mpay" />
  <link rel="manifest" href="manifest.json" />
  <link rel="icon" href="assets/images/logo/favicon.png" type="image/x-icon" />
  <title>mPay App</title>
  <link rel="apple-touch-icon" href="assets/images/logo/favicon.png" />
  <meta name="theme-color" content="#122636" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black" />
  <meta name="apple-mobile-web-app-title" content="mpay" />
  <meta name="msapplication-TileImage" content="assets/images/logo/favicon.png" />
  <meta name="msapplication-TileColor" content="#FFFFFF" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />

  <!--Google font-->
  <link rel="preconnect" href="https://fonts.googleapis.com/" />
  <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&amp;display=swap" rel="stylesheet" />

  <!-- bootstrap css -->
  <link rel="stylesheet" id="rtl-link" type="text/css" href="assets/css/vendors/bootstrap.min.css" />

  <!-- swiper css -->
  <link rel="stylesheet" type="text/css" href="assets/css/vendors/swiper-bundle.min.css" />

  <!-- Theme css -->
  <link rel="stylesheet" id="change-link" type="text/css" href="assets/css/style.css" />
</head>

<body>
  <!-- header start -->
  <header class="section-t-space">
    <div class="custom-container">
      <div class="header-panel">
        <a href="dashboard" class="back-btn">
          <i class="icon" data-feather="arrow-left"></i>
        </a>
        <h2>Transaction history</h2>

        <div class="dropdown" style="display: none">
          <a href="#" class="back-btn" role="button" data-bs-toggle="dropdown">
            <i class="icon" data-feather="settings"></i>
          </a>

          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#">Most recent </a></li>
            <li><a class="dropdown-item" href="#period" data-bs-toggle="modal">Custom</a></li>
            <li><a class="dropdown-item" href="#">Last 1 month</a></li>
            <li><a class="dropdown-item" href="#">Remove all</a></li>
          </ul>
        </div>
      </div>
    </div>
  </header>
  <!-- header end --><?php
$transactions = $userTransactions['transactions'] ?? [];

// Group transactions by date period
$grouped = [];
foreach ($transactions as $t) {
    $date = date("Y-m-d", strtotime($t['created_at']));
    $today = date("Y-m-d");
    $yesterday = date("Y-m-d", strtotime("-1 day"));
    $lastWeek = date("Y-m-d", strtotime("-7 days"));

    if ($date == $today) {
        $grouped['Today'][] = $t;
    } elseif ($date == $yesterday) {
        $grouped['Yesterday'][] = $t;
    } elseif ($date >= $lastWeek && $date < $yesterday) {
        $grouped['Last Week'][] = $t;
    } else {
        $grouped['Older'][] = $t; // fallback
    }
}
?>

<!-- person transaction list section starts -->
<section class="section-b-space">
  <div class="custom-container">
    <?php if (!empty($grouped)): ?>
        <?php foreach ($grouped as $period => $items): ?>
            <div class="title mt-3">
              <h2><?php echo $period; ?></h2>
            </div>

            <div class="row gy-3">
                <?php foreach ($items as $transaction): ?>
                    <?php 
                      // icon map
                      $iconMap = [
                        'deposit'     => 'log-in',
                        'purchase'    => 'shopping-cart',
                        'referral'    => 'user-plus',
                        'activation'  => 'key',
                        'withdrawal'  => 'log-out',
                        'adjustment'  => 'settings',
                      ];
                      $icon = $iconMap[$transaction['type']] ?? 'circle';

                      // color logic
                      $colorClass = ($transaction['type'] === 'withdrawal') ? 'error-color' : 'success-color';
                    ?>
                    
                    <div class="col-12">
                      <div class="transaction-box">
                        <a href="#transaction-detail<?php echo $transaction['id'];?>" data-bs-toggle="modal" class="d-flex gap-3">
                          
                          <div class="transaction-image">
                            <i class="categories-icon icon1" data-feather="<?php echo $icon; ?>"></i>
                          </div>

                          <div class="transaction-details">
                            <div class="transaction-name">
                              <h5><?php echo ucfirst($transaction['type']); ?></h5>
                              <h3 class="<?php echo $colorClass; ?>">
                                <?php echo $site['currency']." ".number_format($transaction['amount'], 2); ?>
                              </h3>
                            </div>

                            <div class="d-flex justify-content-between">
                              <h5 class="light-text"><?php echo ucfirst($transaction['status']); ?></h5>
                              <h5 class="light-text"><?php echo date("h:i a", strtotime($transaction['created_at'])); ?></h5>
                            </div>
                          </div>
                        </a>
                      </div>
                    </div>

                    <!-- Transaction Detail Modal -->
                    <div class="modal successful-modal transfer-details fade" id="transaction-detail<?php echo $transaction['id'];?>" tabindex="-1">
                      <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h2 class="modal-title">Transaction Detail</h2>
                          </div>
                          <div class="modal-body">
                            <ul class="details-list">
                              <li>
                                <h3 class="fw-normal dark-text">Status</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($transaction['status']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Transaction category</h3>
                                <h3 class="fw-normal light-text"><?php echo ucfirst($transaction['type']); ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Reference</h3>
                                <h3 class="fw-normal light-text"><?php echo $transaction['reference']; ?></h3>
                              </li>
                              <li>
                                <h3 class="fw-normal dark-text">Date</h3>
                                <h3 class="fw-normal light-text"><?php echo date("d M, Y h:i a", strtotime($transaction['created_at'])); ?></h3>
                              </li>
                              <li class="amount">
                                <h3 class="fw-normal dark-text">Amount</h3>
                                <h3 class="fw-semibold <?php echo $colorClass; ?>">
                                  <?php echo $site['currency']." ".number_format($transaction['amount'], 2); ?>
                                </h3>
                              </li>
                            </ul>
                          </div>
                          <button type="button" class="btn close-btn" data-bs-dismiss="modal">
                            <i class="icon" data-feather="x"></i>
                          </button>
                        </div>
                      </div>
                    </div>
                    <!-- End Transaction Detail Modal -->

                <?php endforeach; ?>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No transactions found.</p>
    <?php endif; ?>
   <!-- panel-space start -->
  <section class="panel-space"></section>
  <!-- panel-space end -->

  <!-- bottom navbar start -->
 <?php
 include "includes/tabs.php";
 ?>
  </div>
</section>

<script>
  feather.replace();
</script>


  <!-- feather js -->
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/custom-feather.js"></script>

  <!-- bootstrap js -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <!-- script js -->
  <script src="assets/js/script.js"></script>
</body>


<!-- Mirrored from themes.pixelstrap.net/pwa/mpay/transaction-history.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 25 Aug 2025 22:32:42 GMT -->
</html>